﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Text;

using Thomas_Erdoesi.Game_Objects;

namespace Thomas_Erdoesi.Game_Analyzer
{
    public class GameStatus
    {
        public IPAddress Server;

        public FramePacket Frame = new FramePacket();
        public KeysPacket Keys = new KeysPacket();

        public int FrameCounter = 0;
        public int PrevFrameCounter = 0;

        public Spaceship Spaceship = null;
        public Saucer Saucer = null;
        public List<Asteroid> Asteroids = new List<Asteroid>();
        public List<Shot> Shots = new List<Shot>();
        public string Score;

        public GameObjectLocation PrevSpaceshipLocation = null;
        public GameObjectSpeed PrevSpaceshipSpeed = null;
        public double PrevSpaceshipAngle = 0;

        public Saucer PrevSaucer = null;
        public List<Asteroid> PrevAsteroids = null;
        public List<Shot> PrevShots = null;
        public string PrevScore = "";

        /// <summary>
        /// Statusaktualisierung vorbereiten (alten Zustand sichern)
        /// </summary>
        public void PrepareStatusUpdate()
        {
            if (Spaceship != null)
            {
                PrevSpaceshipLocation = new GameObjectLocation(Spaceship.Location.x, Spaceship.Location.y);
                PrevSpaceshipSpeed = new GameObjectSpeed(Spaceship.Speed.sx, Spaceship.Speed.sy);
                PrevSpaceshipAngle = Spaceship.Angle;
            }
            else
            {
                PrevSpaceshipLocation = null;
                PrevSpaceshipSpeed = null;
            }

            PrevSaucer = Saucer;
            PrevAsteroids = Asteroids;
            PrevShots = Shots;
            PrevScore = Score;

            Spaceship.TurnLeftExecuted = Spaceship.TurnLeftPending;
            Spaceship.TurnRightExecuted = Spaceship.TurnRightPending;
            Spaceship.TurnLeftPending = Keys.Left;
            Spaceship.TurnRightPending = Keys.Right;

            Spaceship = null;
            Saucer = null;
            Asteroids = new List<Asteroid>();
            Shots = new List<Shot>();
            Score = "";

            Keys.Initialize();
        }

        /// <summary>
        /// Erwartete Objektpositionen für aktuellen Frame berechnen
        /// </summary>
        public void PredictLocation()
        {
            int NoOfFrames = FrameCounter - PrevFrameCounter;

            foreach (Asteroid CurrentAsteroid in Asteroids) CurrentAsteroid.PredictLocation(NoOfFrames);
            foreach (Shot CurrentShot in Shots) CurrentShot.PredictLocation(NoOfFrames);

            if (Spaceship != null) Spaceship.PredictLocation(NoOfFrames);
            if (Saucer != null) Saucer.PredictLocation(NoOfFrames);
        }
    }
}
